**********************************************************************************
*
* 'descriptive_stats.do'
*
* Generate descriptive statistics for PCAs
*
* Created       on February 04th  2022
* Last modified on February 04th  2022
*
**********************************************************************************

**********************************************************************************
* FOR LOG
cap log close                       
clear                             

log using "./log/descriptive_stats.log.do", replace text

* FOR LOG
display "$S_TIME  $S_DATE"
**********************************************************************************

**********************************************************************************
set more off
cap prog drop _all
**********************************************************************************

use "./output/LRbetas_daily_trade_PCA_resid.dta", clear

keep datey base foreign beta R2_y fx_vol var_adj
rename beta beta_resid
rename R2_y R2_y_resid
rename fx_vol fx_vol_resid
rename var_adj var_adj_resid

tempfile resid
save `resid'

use "./output/LRbetas_daily_trade_PCA.dta", clear

keep datey base foreign beta R2_y fx_vol var_adj

merge 1:1 datey base foreign using `resid'

replace fx_vol = fx_vol*sqrt(252) /* Annualizing volatility */
replace fx_vol_resid = fx_vol_resid*sqrt(252) /* Annualizing volatility */

set more off
eststo clear
estpost summarize beta R2_y fx_vol var_adj beta_resid R2_y_resid fx_vol_resid var_adj_resid, detail 
esttab using "./output/tables/tableA2.tex", ///
cells("count mean(fmt(3)) p50(fmt(3)) sd(fmt(3))") noobs ///
label varlabels(beta "Base Loadings, $ \beta$" ///
				R2_y "Share of Systematic Risk, $ R^2$" ///
				fx_vol "Volatility, $ \sigma$" ///
				var_adj "Unshared Risk, $ \rho$" ///
				beta_resid "Base Loadings, $ \beta$" ///
				R2_y_resid "Share of Systematic Risk, $ R^2$" ///
				fx_vol_resid "Volatility, $ \sigma$" ///
				var_adj_resid "Unshared Risk, $ \rho$") ///
collabels("Observations" "Mean" "Median" "Std. Dev.") nonumber replace

**********************************************************************************
* FOR LOG
display "$S_TIME  $S_DATE"

log close
**********************************************************************************



